#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{1.f,1.f, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{255.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{255.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{1.f,255.f/FOND_Z,1.f/FOND_Z}};

static BYTE FrameBuf3d2[65536];
static WORD DistTab[128][128];
static WORD TanTab[128][128];
static BYTE Tex[256*256];

#define MAX(A,B) ((A>B)?(A):(B))

void LInit_Fondue()
{
	int Cpt1, Cpt2;
	WORD Tmp;
	WORD Tmp1, Tmp2, Tmp3;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		for(Cpt2=0;Cpt2<256;Cpt2++)
		{
			/*Tmp = g_PicFabfou[Cpt1*256+Cpt2];
			Tex[Cpt1*256+Cpt2] = ( ((Tmp&31)<<3) + (((Tmp&(31<<6))<<3)>>6) + (((Tmp&(31<<11))<<3)>>11) )/3;*/
			Tmp1 = 256-sqrt((Cpt1-192)*(Cpt1-192)+(Cpt2-108)*(Cpt2-108))*1.3f;
			Tmp2 = 256-sqrt((Cpt1-68)*(Cpt1-68)+(Cpt2-128)*(Cpt2-128))*1.3f;
			Tmp3 = 256-sqrt((Cpt1-192)*(Cpt1-192)+(Cpt2-192)*(Cpt2-192))*1.3f;
			Tex[Cpt1*256+Cpt2] = MAX(MAX(Tmp1, Tmp2), Tmp3);
			if (Tex[Cpt1*256+Cpt2]<230)
				Tex[Cpt1*256+Cpt2] = 0;
		}
	}

	PrepareTextureFromArray(g_PicFabfou, 256, 256, &g_TextureFabfou);
}

void QInit_Fondue()
{
	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureFabfou);

	g_TextureBuff.info.format = GR_TEXFMT_INTENSITY_8;
	memset(g_FrameBuf3d, 0, 65536*2);
	srand( (unsigned)time( NULL ) );
}

void Effect_Fondue()
{
	DWORD Cpt1, Cpt2;
	BYTE *pDst, *pSrc, *pStart;
	static DWORD PileFace = 0;
	static DWORD Last = 0;
	static DWORD LastFondue = 0;
	BYTE *pTmp;
	DWORD Count;

	if (PileFace)
	{
		pStart = (BYTE*)g_FrameBuf3d;
		pSrc = ((BYTE*)g_FrameBuf3d)+1+256;
		pDst = FrameBuf3d2+1+256;
	}
	else
	{
		pStart = FrameBuf3d2;
		pDst = ((BYTE*)g_FrameBuf3d)+1+256;
		pSrc = FrameBuf3d2+1+256;
	}

	//if ((g_demostate.TickInEffect-Last > 4000)||(Last==0))
	if (Last==0)
	{
		Last = g_demostate.TickInEffect;
		//pStart += 64 + 64*256;
		
		pTmp = &Tex[0];
		Count = 0;
		for(Cpt1=0;Cpt1<256;Cpt1++)
		{
			for(Cpt2=0;Cpt2<256;Cpt2++)
			{
				*(pStart++) |= *(pTmp++);
			}
			//pStart += 128;
		}
	}
	
/*	for(Cpt1=0;Cpt1<50;Cpt1++)
	{
		pSrc[(rand()&0x7f)*256+(rand()&0x7f)+64*256+64] = 0;
	}*/

	if (g_demostate.TickInEffect-LastFondue > 10)
	{
		LastFondue = g_demostate.TickInEffect;
		for(Cpt1=0;Cpt1<254;Cpt1++)
		{
			for(Cpt2=0;Cpt2<254;Cpt2++)
			{
				//*pDst = (BYTE)(((DWORD)pSrc[-1]+(DWORD)pSrc[1]+(DWORD)pSrc[-256]+(DWORD)pSrc[256])/4);
				*pDst = (BYTE)(((DWORD)pSrc[-255]+(DWORD)pSrc[-257]+(DWORD)pSrc[257]+(DWORD)pSrc[255])/4);
				pSrc++;
				pDst++;
			}
			pSrc += 2;
			pDst += 2;
		}
	}
	else
	{
		memcpy(pDst, pSrc, 65536);
	}

	PileFace = ~PileFace;

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureFabfou);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureBuff);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Fondue()
{
	FreeTexture(&g_TextureFabfou);
}
